﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using TMPro;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class TimerSelect : MonoBehaviour
{
    public TextItemsSelector DifficultySelector;
    public TMP_Text HiderTimeText;
    public TMP_Text SeekerTimeText;
    public TextItemsSelector RoundsSelector;

    private void Awake()
    {
        //Subscribe to events, setup the UI
        DifficultySelector.SelectedItemChanged += OnDifficultyChanged;
        HiderTimeText.SetText(MillisecondsToTimeString(GameManager.Instance.EasyHiderTime));
        SeekerTimeText.SetText(MillisecondsToTimeString(GameManager.Instance.EasySeekerTime));
    }

    private string MillisecondsToTimeString(float milliseconds)
    {
        //Return a string of minutes and seconds from a value of milliseconds
        int totalSecs = Convert.ToInt32(milliseconds / 1000.0f);

        return totalSecs + "s";
    }

    private void OnDifficultyChanged(object sender, TextItemsSelector.SelectedItemChangedEventArgs e)
    {
        //Get the new difficulty and setup the UI as appropriate
        switch(e.NewItemText.ToLower())
        {
            case "easy":
                HiderTimeText.SetText(MillisecondsToTimeString(GameManager.Instance.EasyHiderTime));
                SeekerTimeText.SetText(MillisecondsToTimeString(GameManager.Instance.EasySeekerTime));
                break;

            case "medium":
                HiderTimeText.SetText(MillisecondsToTimeString(GameManager.Instance.MediumHiderTime));
                SeekerTimeText.SetText(MillisecondsToTimeString(GameManager.Instance.MediumSeekerTime));
                break;

            case "hard":
                HiderTimeText.SetText(MillisecondsToTimeString(GameManager.Instance.HardHiderTime));
                SeekerTimeText.SetText(MillisecondsToTimeString(GameManager.Instance.HardSeekerTime));
                break;
        }
    }

    public void CheckOptions()
    {
        //Set the game controller's difficulty based on the selected option
        switch(DifficultySelector.SelectedItemText.ToLower())
        {
            case "easy":
                GameController.Difficulty = Constants.Difficulties.Easy;
                break;

            case "medium":
                GameController.Difficulty = Constants.Difficulties.Medium;
                break;

            case "hard":
                GameController.Difficulty = Constants.Difficulties.Hard;
                break;
        }

        //Set the game controller's number of rounds based on the selected option
        switch (RoundsSelector.SelectedItemText.ToLower())
        {
            case "1 round":
                GameController.NumberOfRounds = 1;
                break;

            case "3 rounds":
                GameController.NumberOfRounds = 3;
                break;

            case "5 rounds":
                GameController.NumberOfRounds = 5;
                break;
        }
        
        //All options configured, let's stop the music and load the game
        AudioManager.Instance.StopMusic();

        Loading.SetSceneToLoad("Game");
        SceneManager.LoadScene("Loading");
    }
}
